const { contextBridge, ipcRenderer } = require("electron");

function $api(method, ...args) {
    return ipcRenderer.invoke(method, ...args);
}

function $event(event, listener) {
    ipcRenderer.on(event, listener);
    return function () {
        ipcRenderer.off(event, listener);
    };
}

contextBridge.exposeInMainWorld("$api", $api);
contextBridge.exposeInMainWorld("$event", $event);
